<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class Slick_Menu_Plugin_Updater {

	/**
	 * The main plugin object.
	 * @var 	object
	 * @access  public
	 * @since 	1.0.0
	 */

    protected $manager;
    protected $license;
    protected $product;
    protected $read_only;

	protected $update_url = "https://repo.xplodedthemes.com/updates.php?action=get_metadata&slug={slug}&market={market}";

    public function __construct( $license, $product, $read_only = false ) {

        $this->license = $license;
        $this->product  = $product;
        $this->read_only = $read_only;

        $this->update_url = str_replace(
            array(
                '{slug}',
                '{market}'
            ),
            array(
                $this->product->premium_slug,
                $this->product->market,
            ),
            $this->update_url
        );

        $updateChecker = Puc_v4_Factory::buildUpdateChecker(
            $this->update_url,
            $this->product->file
        );
		
		$updateChecker->addQueryArgFilter(array($this, 'filter_update_checker'));
	}

	public function filter_update_checker($queryArgs) {

        if ( !$this->read_only && ! empty( $this->license ) && $this->license->getLocalLicense() !== false ) {

            $product = $this->license->getLocalLicense()->license;

            $queryArgs['purchase_code'] = $product->purchase_code;
            $queryArgs['product_id']    = $product->product_id;
            $queryArgs['domain']        = $product->domain;

        } else {

            $queryArgs['purchase_code'] = '';
            $queryArgs['product_id']    = '';
            $queryArgs['domain']        = '';
        }

        return $queryArgs;
	}

}
